<?php

if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("datahandler_post_insert_thread", "thread_count_pro_plus");
$plugins->add_hook("class_moderation_delete_thread_start", "thread_count_pro_minus");
$plugins->add_hook("admin_tools_recount_rebuild_output_list", "thread_count_pro_showreset");
$plugins->add_hook("admin_tools_recount_rebuild_start", "thread_count_pro_dothereset");
$plugins->add_hook("member_profile_end", "thread_count_pro_member_profile");
$plugins->add_hook("global_start", "thread_count_pro_load_lang");

function thread_count_pro_info()
{
	return array(
		"name"			=> "هاك عدد مواضيع العضو",
		"description"	=> "يقوم باضافة خانة جديدة خاصه بعدد مواضيع العضو",
		"website"		=> "http://mods.mybboard.net/view/thread-count-pro/",
		"author"		=> "Santiago Dimattía",
		"authorsite"	=> "http://teleportz.com.ar",
		"version"		=> "1.1",
		"guid"			=> "7828da28ad106897623650d90e54e574",
		"compatibility"	=> "16*"
	);
}

/**
 * Load the lang file
 *
 */
function thread_count_pro_load_lang()
{
	global $lang;
	
	$lang->load('thread_count_pro');
}

/**
 * Render the stats in the Member Profile
 *
 */
function thread_count_pro_member_profile()
{
	global $lang, $memprofile, $daysreg, $cache;

	// Math: Threads per day
	$ttd = $memprofile['threadnum'] / $daysreg;
	$ttd = round($ttd, 2);
	if($ttd > $memprofile['threadnum'])
	{
		$ttd = $memprofile['threadnum'];
	}

	// Math: Percent of threads
	$stats = $cache->read('stats');
	$numposts = $stats['numthreads'];
	if($numposts == 0)
	{
		$percent = "0";
	}
	else
	{
		$percent = $memprofile['threadnum']*100/$numposts;
		$percent = round($percent, 2);
	}
	
	if($percent > 100)
	{
		$percent = 100;
	}

	// End math things
	$lang->threads_statistics = $lang->sprintf($lang->threads_statistics, my_number_format($ttd), $percent);
}

/**
 * Install
 *
 */
function thread_count_pro_install()
{
	global $db;

	$db->write_query("ALTER TABLE `".TABLE_PREFIX."users` ADD `threadnum` INT(10) NOT NULL DEFAULT '0';");
}

/**
 * Uninstall
 *
 */
function thread_count_pro_uninstall()
{
	global $db;

	$db->write_query("ALTER TABLE `".TABLE_PREFIX."users` DROP `threadnum`;");
}

/**
 * Check if installed
 *
 */
function thread_count_pro_is_installed()
{
	global $db;

	if($db->field_exists('threadnum', 'users'))
	{
		return TRUE;
	}

	return FALSE;
}

/**
 * Activate
 *
 */
function thread_count_pro_activate()
{
	require_once MYBB_ROOT."/inc/adminfunctions_templates.php";

	find_replace_templatesets('member_profile',
		'#' . preg_quote('<span class="smalltext">(<a href="search.php?action=finduserthreads&amp;uid={$uid}">{$lang->find_threads}</a> &mdash; <a href="search.php?action=finduser&amp;uid={$uid}">{$lang->find_posts}</a>)</span></td>
</tr>') . '#',
		'<span class="smalltext">(<a href="search.php?action=finduser&amp;uid={$uid}">{$lang->find_posts}</a>)</span></td>
</tr>
<!-- CountThreads -->
<tr>
<td class="trow1"><strong>{$lang->total_threads}</strong></td>
<td class="trow1">{$memprofile[\'threadnum\']} ({$lang->threads_statistics})<br /><span class="smalltext">(<a href="search.php?action=finduserthreads&amp;uid={$uid}">{$lang->find_threads}</a>)</span></td>
</tr>
<!-- /CountThreads -->');

	find_replace_templatesets('postbit_author_user',
		'#' . preg_quote('{$lang->postbit_posts} {$post[\'postnum\']}<br />') . '#',
		'{$lang->postbit_posts} {$post[\'postnum\']}<br /><!-- CountThreads -->{$lang->postbit_threads} {$post[\'threadnum\']}<br /><!-- /CountThreads -->'
	);

}

/**
 * Deactivate
 *
 */
function thread_count_pro_deactivate()
{
	require_once MYBB_ROOT."/inc/adminfunctions_templates.php";

	find_replace_templatesets('member_profile', '#\<!--\sCountThreads\s--\>(.+)\<!--\s/CountThreads\s--\>#is', '', 0);
	find_replace_templatesets('postbit_author_user', '#\<!--\sCountThreads\s--\>(.+)\<!--\s/CountThreads\s--\>#is', '', 0);
	find_replace_templatesets('member_profile',
		'#' . preg_quote('<span class="smalltext">(<a href="search.php?action=finduser&amp;uid={$uid}">{$lang->find_posts}</a>)</span></td>') . '#',
		'<span class="smalltext">(<a href="search.php?action=finduserthreads&amp;uid={$uid}">{$lang->find_threads}</a> &mdash; <a href="search.php?action=finduser&amp;uid={$uid}">{$lang->find_posts}</a>)</span></td>');
}

/**
 * Add one to the user thread count
 *
 */
function thread_count_pro_plus($thread)
{
	global $mybb, $db;

	// Don't try to update the threadnum if the thread was made by a guest
	if(!$thread->data['uid'])
	{
		return false;
	}

	// Just checking, you know
	if($thread->data['uid'] == $mybb->user['uid'])
	{
		$uid = $mybb->user['uid'];
		$value = $mybb->user['threadnum'];
	}
	else
	{
		$q = $db->simple_select('users', 'threadnum', 'uid = ' . $thread['username'], array('limit' => 1));
		$value = $db->fetch_field('threadnum', $q);
		$uid = $thread->data['uid'];
	}

	$new_value = ++$value;

	$db->update_query('users', array('threadnum' => $new_value), 'uid = ' . $uid);
}

/**
 * Substract one from the user thread count
 *
 */
function thread_count_pro_minus($tid)
{
	global $mybb, $db, $thread;

	$q = $db->query('SELECT t.uid, u.threadnum FROM ' . TABLE_PREFIX . 'threads t JOIN ' . TABLE_PREFIX . 'users u ON t.uid = u.uid WHERE t.tid = ' . $tid . ' LIMIT 1');
	$result = $db->fetch_array($q);

	// Don't try to update the threadnum if the thread was made by a guest (UID: 0)
	if(!$result['uid'])
	{
		return false;
	}

	$threadnum = $result['threadnum'] - 1;
	$uid = $result['uid'];

	$db->update_query('users', array('threadnum' => $threadnum), 'uid = ' . $uid);
}

/**
 * Recount thread count
 *
 */
function thread_count_pro_recount()
{
	global $db, $mybb, $lang;

	$lang->load('thread_count_pro');
	
	$query = $db->simple_select("users", "COUNT(uid) as num_users");
	$num_users = $db->fetch_field($query, 'num_users');
	
	$page = intval($mybb->input['page']); if($page == 0) : $page = 1; endif;
	$per_page = intval($mybb->input['userthreads']);
	$start = ($page-1) * $per_page;
	$end = $start + $per_page;
	
	$query = $db->simple_select("forums", "fid", "usepostcounts = 0");
	while($forum = $db->fetch_array($query))
	{
		$fids[] = $forum['fid'];
	}
	if(is_array($fids))
	{
		$fids = implode(',', $fids);
	}
	if($fids)
	{
		$fids = " AND t.fid NOT IN($fids)";
	}
	else
	{
		$fids = "";
	}
	
	$query = $db->simple_select("users", "uid", '', array('order_by' => 'uid', 'order_dir' => 'asc', 'limit_start' => $start, 'limit' => $per_page));
	while($user = $db->fetch_array($query))
	{		
		$query2 = $db->query("
			SELECT COUNT(tid) AS thread_count
			FROM ".TABLE_PREFIX."threads t
			WHERE uid='{$user['uid']}' AND t.visible > 0{$fids}
		");
		$num_threads = $db->fetch_field($query2, "thread_count");
		
		$db->update_query("users", array("threadnum" => intval($num_threads)), "uid='{$user['uid']}'");
	}
	
	check_proceed($num_users, $end, ++$page, $per_page, "userthreads", "do_recountuserthreads", $lang->thread_count_recount_okay);
}

/**
 * Show options to recount the threads
 *
 */
function thread_count_pro_showreset()
{
	global $form, $form_container, $lang;

	$lang->load('thread_count_pro');

	$form_container->output_cell("<label>{$lang->thread_count_recount}</label><div class=\"description\">{$lang->thread_count_recount_description}</div>");
	$form_container->output_cell($form->generate_text_box("userthreads", 500, array('style' => 'width: 150px;')));
	$form_container->output_cell($form->generate_submit_button($lang->go, array("name" => "do_recountuserthreads")));
	$form_container->construct_row();
}

/**
 * Recount
 *
 */
function thread_count_pro_dothereset()
{
	global $mybb;

	if($mybb->request_method == "post" && isset($mybb->input['do_recountuserthreads']))
	{
		thread_count_pro_recount();
	}
}

/** FILE END **/